<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/4
 * Time: 下午1:29
 */

namespace Mainto\RpcServer\RpcClient;


use Exception;
use Mainto\RpcServer\Exceptions\RpcInvokeException;
use Mainto\RpcServer\RpcUtil\Block\InvokeControlBlock;
use Mainto\RpcServer\RpcUtil\Block\SuccessReturnBlock;
use Mainto\RpcServer\RpcUtil\RpcBlock;
use RuntimeException;

class RpcClass {
    private static $instances = [];
    /**
     * Rpc 客户端
     * @var RpcClient
     */
    private $client;
    /**
     * 调用服务名
     * @var string
     */
    private $serviceName;
    /**
     * 调用类名
     * @var string
     */
    private $className;
    /**
     * 缓存Key
     * @var string
     */
    private $cacheKey = "";

    /**
     * RpcClass constructor.
     * @param $cacheKey
     * @param RpcClient $client
     * @param string $serviceName
     * @param string $className
     */
    private function __construct ($cacheKey, RpcClient $client, string $serviceName, string $className) {
        $this->cacheKey = $cacheKey;
        $this->client = $client;
        $this->serviceName = $serviceName;
        $this->className = $className;
    }

    /**
     * 获得一个远程调用实例
     *
     * @param $serviceName
     * @param $className
     * @return RpcClass
     */
    public static function getClass ($serviceName, $className) {
        $key = "{$serviceName}->{$className}";
        if (!isset(self::$instances[$key])) {
            $client = RpcClient::getInstanceByServiceName($serviceName);
            if (!$client) {
                throw new RuntimeException("can not find or connect to server {$serviceName}");
            }

            self::$instances[$key] = new RpcClass($key, $client, $serviceName, $className);
        }

        return self::$instances[$key];
    }

    /**
     * 函数调用
     * @param $name
     * @param $arguments
     * @return RpcStreamResponse|RpcBlock|null
     * @throws Exception
     */
    public function __call ($name, $arguments) {
        if (count($arguments) == 1) {
            $arguments = $arguments[0] ?? $arguments;
        }
        $invoke = new InvokeControlBlock($this->className, $name, $arguments);
        if ($this->client->isClose()) {
            $this->client->close();
            for ($i = 0; $i < 3; $i++) {
                try {
                    $client = RpcClient::getInstanceByServiceName($this->serviceName);
                    if (!$client) {
                        throw new RuntimeException("can not find or connect to server {$this->serviceName}");
                    }
                    $this->client = $client;
                    break;
                } catch (\Exception $exception) {
                    if ($i == 2) {
                        throw $exception;
                    } else {
                        sleep(3);
                    }
                }
            }
        }
        $block = $this->client->sendBlock($invoke);

        if ($block instanceof SuccessReturnBlock) {
            return $block->getMessage();
        } elseif ($block instanceof RpcStreamResponse) {
            return $block;
        } else {
            throw new RpcInvokeException($block);
        }
    }

    /**
     * 捕捉异常
     *
     * @param Exception $e
     * @return bool
     */
    private function handleSocketException (Exception $e): bool {
        if ($e->getMessage() == "socket read error") {
            $this->client->close();
            $this->client = RpcClient::getInstanceByServiceName($this->serviceName);
            if ($this->client) {
                return true;
            }
        }

        if ($this->client) $this->client->close();
        if (isset(self::$instances[$this->cacheKey])) {
            unset(self::$instances[$this->cacheKey]);
        }
        return false;
    }
}