
namespace Mainto\Bridge\Invokes\{{$namespace}};

use Mainto\RpcServer\RpcClient\RpcClass;
use InvalidArgumentException;

/**
 * Class Unique
@foreach($methods as $method)
 * @@method {{$method['name']}}ByParams(array $params)
@endforeach
 */
class {{$shortClassName}} {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

@foreach($methods as $method)
    /**
@foreach($method['doc'] as $doc)
     * {{$doc}}
@endforeach
@if($method['isDeprecated'])
     * @deprecated
@endif
     *
@foreach ($method['params'] as $param)
@if(in_array($param->name, $method['args']))
     * @param {{$param->type}} ${{$param->name}} {{$param->comment}} [ require true ]
@else
     * @support {{$param->type}} ${{$param->name}} {{$param->comment}} {{$param->require ? '[ require true ]' : ''}}
@endif
@endforeach
     * @throws \Exception
     * @return {{$method['returnType']}}
     */
    public static function {{$method['name']}} ({!! $method['argStr'] !!}) {
    @if($method['argStr'])
    return self::getClass()->{{$method['name']}}([
@foreach($method['args'] as $key)
            "{{$key}}" => ${{$key}},
@endforeach
        ]);
    @else
    return self::getClass()->{{$method['name']}}();
    @endif
}

@endforeach
    /**
     * getClass
     * @deprecated
     * @throws \Exception
     * @return mixed
     */
    public static function getClass () {
        return RpcClass::getClass('{{$microName}}', '{{$className}}');
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}