<?php


namespace Mainto\HimoCommon\Enum;

/**
 * 统一品牌 enum
 *
 * Class BrandEnum
 * @package Mainto\HimoCommon\Enum
 */
class BrandEnum {
    const HIMO = 'himo';                    #海马体
    const HIMO_BLUE = 'himo_blue';          #海马体蓝标
    const HIMO_GOLD = 'himo_gold';          #海马体大师
    const HIMO_KIDS = 'himo_kids';          #海马体儿童
    const FAMILY = 'family';                #海马体家庭
    const MANTU = 'mantu';                  #缦图摄影
    const HIMO_LENS = 'himo_lens';          #海马体莱斯学院
    const HIMO_BUSINESS = 'himo_business';  #海马体企业版
    const SHOW_PIC = 'show_pic';            #修修兽
    const WINDCCI = 'windcci';              #海马体彩妆

    #全部brand
    const ALL_BRAND = [
        self::HIMO,
        self::HIMO_BLUE,
        self::HIMO_GOLD,
        self::HIMO_KIDS,
        self::FAMILY,
        self::MANTU,
        self::HIMO_LENS,
        self::HIMO_BUSINESS,
        self::SHOW_PIC,
        self::WINDCCI,
    ];

    #全部品牌名称映射
    const ALL_BRAND_NAME_MAP = [
        self::HIMO          => '海马体',
        self::HIMO_BLUE     => '海马体蓝标',
        self::HIMO_GOLD     => '海马体大师',
        self::HIMO_KIDS     => '海马体儿童',
        self::FAMILY        => '海马体家庭',
        self::MANTU         => '缦图摄影',
        self::HIMO_LENS     => '海马体莱斯学院',
        self::HIMO_BUSINESS => '海马体企业版',
        self::SHOW_PIC      => '修修兽',
        self::WINDCCI       => '海马体彩妆',
    ];
}