<?php

namespace Mainto\Elasticsearch;

use Mainto\RpcServer\Tracing\Extend\TraceAOP;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;

/**
 * es帮助类  目前为单机模式
 * Class EsService
 * @package App\Service
 *
 * @mixin Service
 */
final class EsService extends TraceAOP {
    /**
     * @var EsService|null
     */
    public static ?EsService $instance = null;

    /**
     * @var int
     */
    protected int $spanKind = SpanKind::KIND_CLIENT;

    /**
     * @var string
     */
    protected string $spanName = 'Elasticsearch EsService::%s';

    /**
     * @var string
     */
    protected string $spanAttributeKey = 'es.params';

    /**
     * @return EsService
     */
    public static function getInstance (): self {
        if (null == self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * 私有化实例函数
     */
    private function __construct () {
        // 构建es client
        $this->classObject = new Service([
            'hosts'   => [
                env('ES_HOST', 'elasticsearch-master-headless.database-elasticsearch:9200'),
            ],
            'retries' => 2,
        ]);
    }

    /**
     * 设置默认索引
     * @param string $index
     * @return $this
     */
    public function setDefaultIndex (string $index): self {
        $this->classObject->setDefaultIndex($index);
        return $this;
    }

    /**
     * 设置默认type
     * @param string $type
     * @return $this
     */
    public function setDefaultType (string $type): self {
        $this->classObject->setDefaultType($type);
        return $this;
    }

    private function __clone () { }
}

