<?php

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

if (!function_exists('getPost')) {
    function getPost (string $url, array $data): array {
        try {
            $client = new Client([
                'headers' => ['Content-Type' => 'application/json'],
            ]);
            $response = $client->request('POST', $url, [
                'body' => [
                    'body' => json_encode(array_merge($data, ['timeout' => 3]), JSON_UNESCAPED_SLASHES),
                ],
            ]);
            return json_decode($response->getBody()->getContents());
        } catch (GuzzleException $e) {
            // 错误全部上传日志
//            RpcLog::getInstance()->error('dmp.client.error', [
//                'msg' => $e->getMessage(),
//            ]);
            return [];
        }
    }
}


if (!function_exists('objectToArray')) {
    function objectToArray ($array) {
        if (is_object($array)) {
            $array = (array)$array;
        }
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $array[$key] = objectToArray($value);
            }
        }
        return $array;
    }
}
