<?php

namespace Mainto\DMP;

use Mainto\DMP\Cmd\UserListCMD;
use Mainto\DMP\Config\DmpConfig;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;

class Service {

    /**
     * @description 人群用户接口
     * @return array
     */
    public static function sendUserList (UserListCMD $userListCMD): array {
        if (empty($userListCMD)) {
            throw new RpcRuntimeException('userListCMD not empty');
        }
        $url = self::getUrl($userListCMD->version);
        return getPost($url.DmpConfig::DMP_USER_LIST, objectToArray($userListCMD));
    }

    /**
     * @description 用户所在人群
     * @return array
     */
    public static function sendGroupList (array $userIds, string $version): array {
        if (empty($userIds)) {
            throw new RpcRuntimeException('userId not empty');
        }
        $url = self::getUrl($version);
        return getPost($url.DmpConfig::DMP_GROUP_LIST, $userIds);
    }

    /**
     * @param string $version
     * @return string
     */
    public static function getUrl (string $version): string {
        if ($version != 'prod') {
            $url = 'http://127.0.0.1:8080';
        } else {
            $url = 'https://www.baidu.com';
        }
        return $url;
    }

}