<?php

namespace Mainto\DMP;

use Mainto\DMP\Cmd\UserListCMD;
use Mainto\DMP\DTO\UserListDTO;
use Mainto\DMP\Translator\IndexTranslator;
use Mainto\RpcServer\Tracing\Extend\TraceAOP;

class DmpService extends TraceAOP {

    /**
     * @description 人群用户接口
     * @param UserListCMD $userListCMD
     * @return UserListDTO
     */
    public function sendUserList (UserListCMD $userListCMD): UserListDTO {
        return IndexTranslator::toUserList(Service::sendUserList($userListCMD));
    }

    /**
     * @description 用户所在人群
     * @param int $userId
     * @param string $version
     * @return array<int>
     */
    public function sendGroupList (int $userId, string $version): array {
        return Service::sendGroupList($userId, $version);
    }
}