<?php

namespace Mainto\DMP;

use Mainto\DMP\Cmd\UserListCMD;
use Mainto\DMP\Config\DmpConfig;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;

class Service {

    /**
     * @description 人群用户接口
     * @return array
     */
    public static function sendUserList (UserListCMD $userListCMD): array {
        if (empty($userListCMD)) {
            throw new RpcRuntimeException('userListCMD not empty');
        }
        return guzzlePost(DmpConfig::VERSION_MAP[$userListCMD->version].DmpConfig::DMP_USER_LIST, objectToArray($userListCMD));
    }

    /**
     * @description 用户所在人群
     * @return array
     */
    public static function sendGroupList (int $userId, string $version): array {
        if (empty($userId)) {
            throw new RpcRuntimeException('userId not empty');
        }
        return guzzleGet(DmpConfig::VERSION_MAP[$version].DmpConfig::DMP_GROUP_LIST, ['userId' => $userId]);
    }


}