<?php
namespace Mainto\Debug;

use Illuminate\Events\EventServiceProvider;
use Mainto\RpcServer\RpcServer\Kernel;

class DebugProvider extends EventServiceProvider {
    /**
     * @return void
     */
    public function register () {
        $this->substitute();
        $this->bind();
    }

    /**
     * 进行对象替换继承
     *
     * @return void
     */
    private function substitute (): void {
//        $this->app->extend(Kernel::class, function ($factory, $app) {
//            return new HttpFactory($factory->getDispatcher());
//        });
    }

    /**
     * 进行对象绑定
     *
     * @return void
     */
    private function bind (): void {
        $this->app->bind(Kernel::class, function ($app, array $params = []) {
            return new DebugKernel($params['conn'], $params['streamId']);
        });
    }
}