<?php

namespace Mainto\Debug\Reporter;

use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\Tracing\Tracer;
use Throwable;
/**
 * Reporter
 */
class Reporter {
    /**
     * @var Reporter|null
     */
    private static ?Reporter $_instance = null;

    /**
     * @var array
     */
    private array $versions;

    private ReporterInterface $reporter;

    /**
     * 私有化构造方法
     */
    private function __construct () {
        $this->reporter = new HttpHandler();
        // 获取所有version，链路记录Laravel框架、Sidecar、RPC框架、当前服务版本
        $this->versions = RpcDefinition::getInstance()->allVersion();
    }

    /**
     * 获取单例对象
     * @return Reporter
     */
    public static function getInstance (): Reporter {
        if (is_null(static::$_instance)) {
            static::$_instance = new static();
        }
        return self::$_instance;
    }

    /**
     * @param array $coverList
     * @return void
     * @throws Throwable
     */
    public function upload(array $coverList) {
        // 数据结构
        $uploadData = [
            'serviceName' => config('rpc-server.service_name', 'NoName'),
            'serviceVersion' => $this->versions['ServiceVersion'],
            'traceId' => Tracer::getInstance()->getTraceId(),
            'reportTime' => time(),
            'coverList' => $coverList,
        ];
        // 进行上报
        $this->reporter->upload($uploadData);
    }
}