<?php

namespace Mainto\Debug\Reporter;

use GuzzleHttp\Client;
use Throwable;

class HttpHandler implements ReporterInterface {

    /**
     * @var string
     */
    protected string $uri;

    /**
     * 实例化
     */
    public function __construct() {
        $this->uri = env('DEBUG_COVERAGE_URI', false);
    }

    /**
     * @throws Throwable
     */
    public function upload (array $arr) {
        $client = new Client();
        $client->post($this->uri, $arr);
    }
}