<?php

namespace Mainto\Debug\Middlewares;

use Closure;
use Mainto\Debug\Reporter\HttpHandler;
use Mainto\Debug\Reporter\Reporter;
use Throwable;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\KernelMiddleware;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class XdebugKernelMiddleware implements KernelMiddleware {
    /**
     * @param RpcStreamContext $context
     * @param Closure $next
     * @return Response
     * @throws Throwable
     */
    public function handle (RpcStreamContext $context, Closure $next): Response {
        // 获取环境变量，确定是否需要开启xdebug
        if (env('CODE_COVERAGE_OPEN', false) && function_exists('xdebug_start_code_coverage')) {
            xdebug_start_code_coverage();
            $response = $next($context);
            Reporter::getInstance()->upload(xdebug_get_code_coverage());
            // echo json_encode(xdebug_get_code_coverage()) . PHP_EOL;
        } else {
            $response = $next($context);
        }
        return $response;
    }
}