<?php

namespace Mainto\DDDCore\Command\Models;

use Carbon\Carbon;
use Illuminate\Support\Str;
use Mainto\DDDCore\Interfaces\Identity;
use Mainto\RpcServer\Util\Language;
use ReflectionProperty;

class ClassRef extends \Mainto\RpcServer\Util\ObjectMapper\ClassRef {

    /**
     * @var array<Property>
     */
    public array $properties;

    private array $simpleType = [
        Carbon::class,
    ];

    /**
     * 分析类 public 属性
     */
    public function loadProperties () {
        $defaultProperties = $this->class->getDefaultProperties();

        $this->properties = array_map(function (ReflectionProperty $reflectionProperty) use ($defaultProperties) {
            $property = new Property();
            [$property->type, $childType] = $this->getType($reflectionProperty, $this);
            if (Str::endsWith($property->type, '[]') && !in_array($childType, Language::$simpleType)) {
                $property->relationType = "HasMany";
                $property->targetType = $childType;
            }

            if (!Str::endsWith($property->type, '[]')
                && !in_array($property->type, Language::$simpleType)
                && !in_array(Identity::class, class_implements($property->type))
                && !in_array($property->type, $this->simpleType)
            ) {
                $property->relationType = "HasOne";
                $property->targetType = $property->type;
            }

            $property->name = $reflectionProperty->name;

            if (array_key_exists($property->name, $defaultProperties)) {
                $property->default = $defaultProperties[$property->name];
                $property->hasDefault = true;
            }

            return $property;
        }, $this->class->getProperties(ReflectionProperty::IS_PUBLIC));
    }
}
