@startuml test
@foreach($packages as $package)
package {{ $package->getPackageName() }} {
@if($package->enums)
    package enum {
@foreach($package->enums as $enum)
    @if($enum->comment)
    note top of {{ $enum->name }} : {{ $enum->comment  }}
    @endif
    enum {{ $enum->name }} {
@foreach($enum->values as $value)
    @if($value->comment)
        // {{ $value->comment }}
    @endif
        {{ $value->name }} = {!! var_export_min($value->value) !!}
@endforeach
       }
@endforeach
    }
@endif

@if($package->entities)
    package entity {
@foreach($package->entities as $entity)
@if($entity->comment)
        note top of {{ $entity->name }} : {{ $entity->comment  }}
@endif
        entity {{ $entity->name }} {
@if($entity->relationships)
            .. relationships ..
@foreach($entity->relationships as $relationship)
            + {{ $relationship->targetType }} {{ $relationship->name }}
@endforeach
@endif
            .. properties ..
@foreach($entity->properties as $property)
@if($property->comment)
            // {{ $property->comment }}
@endif
@if($property->hasDefault)
            + {{ class_basename($property->type) }} {{ $property->name }} = {!! var_export_min($property->default) !!}
@else
            + {{ class_basename($property->type) }} {{ $property->name }}
@endif
@endforeach
@if($entity->methods)
            .. methods ..
@foreach($entity->methods as $method)
    @if($method->comment)
        // {{ $method->comment }}
    @endif
        + {{ $method->name }}(): {{ $method->returnType }}
@endforeach
@endif
        }
@foreach($entity->relationships as $relationship)
@if($relationship->relationType == "HasOne")
    {{ $entity->name }}::{{ $relationship->name }} "1" --> "1" {{ $relationship->targetType }}
@elseif($relationship->relationType == "HasMany")
    {{ $entity->name }}::{{ $relationship->name }} "1" --> "n" {{ $relationship->targetType }}
@elseif($relationship->relationType == "BelongsTo")
    {{ $entity->name }}::{{ $relationship->name }} "1" <-- "1" {{ $relationship->targetType }}
@endif
@endforeach
@foreach($entity->properties as $property)
@if($property->relationType == "HasOne")
    {{ $entity->name }}::{{ $property->name }} "1" --> "1" {{ class_basename($property->targetType) }}
@elseif($property->relationType == "HasMany")
    {{ $entity->name }}::{{ $property->name }} "1" --> "n" {{ class_basename($property->targetType) }}
@endif
@endforeach
@endforeach
    }
@endif

@if($package->valueObjects)
    package vo {
@foreach($package->valueObjects as $valueObject)
@if($valueObject->comment)
            note top of {{ $valueObject->name }} : {{ $valueObject->comment  }}
@endif
@if($valueObject->isAbstract)
        abstract class {{ $valueObject->name }} {
@else
        class {{ $valueObject->name }} {
@endif
@if($valueObject->relationships)
            .. relationship ..
@foreach($valueObject->relationships as $relationship)
            + {{ $relationship->targetType }} {{ $relationship->name }}
@endforeach
@endif
            .. properties ..
@foreach($valueObject->properties as $property)
@if($property->comment)
            // {{ $property->comment }}
@endif
@if($property->hasDefault)
            + {{ $property->type }} {{ $property->name }} = {!! var_export_min($property->default) !!}
@else
            + {{ $property->type }} {{ $property->name }}
@endif
@endforeach
@if($valueObject->methods)
            .. methods ..
@foreach($valueObject->methods as $method)
    @if($method->comment)
            // {{ $method->comment }}
    @endif
            + {{ $method->name }}(): {{ $method->returnType }}
@endforeach
@endif
        }
@if($valueObject->parent)
        {{ $valueObject->name }} --|> {{ $valueObject->parent }}
@endif
@endforeach
    }
@endif
}
@endforeach
@enduml
