@startuml test
@foreach($packages as $package)
package {{ $package->getPackageName() }} {
@if($package->enums)
    package enum {
@foreach($package->enums as $enum)
    @if($enum->comment)
    note top of {{ $enum->name }} : {{ $enum->comment  }}
    @endif
    enum {{ $enum->name }} {
@foreach($enum->values as $value)
    @if($value->comment)
        // {{ $value->comment }}
    @endif
        {{ $value->name }} = {!! var_export_min($value->value) !!}
@endforeach
       }
@endforeach
    }
@endif

@if($package->entities)
    package entity {
@foreach($package->entities as $entity)
@if($entity->comment)
        note top of {{ $entity->name }} : {{ $entity->comment  }}
@endif
        entity {{ $entity->name }} {
@if($entity->relationships)
            .. relationship ..
@foreach($entity->relationships as $relationship)
            + {{ $relationship->targetType }} {{ $relationship->name }}
@endforeach
@endif
            .. properties ..
@foreach($entity->properties as $property)
@if($property->comment)
            // {{ $property->comment }}
@endif
@if($property->hasDefault)
            + {{ $property->type }} {{ $property->name }} = {!! var_export_min($property->default) !!}
@else
            + {{ $property->type }} {{ $property->name }}
@endif
@endforeach
@foreach($entity->methods as $method)
    @if($method->comment)
        // {{ $method->comment }}
    @endif
        + {{ $method->name }}(): {{ $method->returnType }}
@endforeach
        }
@endforeach
    }
@endif
}
@endforeach
@enduml
