<?php

namespace Mainto\DDDCore\Command\Models;

use Mainto\RpcServer\Util\Types\Map;

class Package {
    private string $packageName;

    /**
     * @var array<Model>
     */
    public array $models = [];

    /**
     * @var Map
     */
    public Map $packages;

    public int $level;

    public function __construct (string $packageName, int $level) {
        $this->packageName = $packageName;
        $this->packages = new Map();
        $this->level = $level;
    }

    /**
     * @return string
     */
    public function getPackageName (): string {
        return $this->packageName;
    }

    public function firstOrNewPackage(string $packageName): Package {
        $subPackage = $this->packages->get($packageName);
        if ($subPackage) {
            return $subPackage;
        } else {
            return tap(new self($packageName, $this->level + 1), function (Package $package) use ($packageName) {
                $this->packages->set($packageName, $package);
            });
        }
    }

    public function each(callable $func) {
        $this->packages->each($func);
    }

    /**
     * @return Map
     */
    public function getPackages (): Map {
        return $this->packages;
    }
}
