<?php

namespace Mainto\DDDCore\Command\Models;

use Mainto\RpcServer\Util\Types\Map;

class Uml {
    /**
     * @var Map<Package>
     */
    private Map $packages;

    public function __construct () {
        $this->packages = new Map();
    }

    public function findOrNewPackage (string $packageName): Package {
        $find = $this->packages->get($packageName);
        if ($find) {
            return $find;
        }

        return tap(new Package($packageName), function (Package $value) use ($packageName) {
            $this->packages->set($packageName, $value);
        });
    }

    public function each(callable $func) {
        $this->packages->each($func);
    }

    /**
     * @return Map
     */
    public function getPackages (): Map {
        return $this->packages;
    }
}
