<?php


namespace Mainto\DDDCore\Relation;


/**
 * Interface HasOneProvider
 * @package Mainto\DDDCore\Relation
 * @template T
 */
interface HasOneProvider {
    /**
     * @return string
     */
    public function getForeignKey(): string;

    /**
     * @return string|array
     */
    public function getLocalKey();

    /**
     * [class, method]
     * @return array<T>
     */
    public function modelToOne(): array;

    /**
     * [class, method]
     * @return array<T>
     */
    public function modelsToOne(): array;
}
