<?php


namespace Mainto\DDDCore\Relation;


class HasOneDefaultProvider implements HasOneProvider{
    /**
     * @var array|string
     */
    private $localKey;
    private string $targetKey;
    private array $modelOne;
    private array $modelsOne;

    /**
     * @param array|string $localKey
     * @param string $targetKey
     * @param array $modelToOne
     * @param array $modelsToOne
     */
    public function __construct ($localKey, string $targetKey, array $modelToOne, array $modelsToOne) {
        $this->localKey = $localKey;
        $this->targetKey = $targetKey;
        $this->modelOne = $modelToOne;
        $this->modelsOne = $modelsToOne;
    }

    public function getForeignKey (): string {
        return $this->targetKey;
    }

    public function getLocalKey () {
        return $this->localKey;
    }

    public function modelToOne (): array {
        return $this->modelOne;
    }

    public function modelsToOne (): array {
        return $this->modelsOne;
    }
}
