<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Exception\MissRelationResultProvider;

/**
 * Class HasMany
 * @package Mainto\DDDCore\Relation
 */
class HasMany implements Relationship {
    /**
     * @var HasManyProvider
     */
    private HasManyProvider $provider;

    public static function from(HasManyProvider $provider): self {
        return new self($provider);
    }

    /**
     * HasMany constructor.
     * @param HasManyProvider $provider
     */
    public function __construct (HasManyProvider $provider) {
        $this->provider = $provider;
    }

    public function getLocalKey (): string {
        return $this->provider->getLocalKey();
    }

    public function getForeignKey (): string {
        return $this->provider->getForeignKey();
    }

    public function modelResult (...$id): iterable {
        $call = $this->provider->modelToMany();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}(...$id);
    }

    public function modelsResult ($ids): iterable {
        $call = $this->provider->modelsToMany();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($ids);
    }

    public function getCurrentKey (): string {
        return $this->provider->getLocalKey();
    }

    public function getTargetKey (): string {
        return $this->provider->getForeignKey();
    }
}
