<?php


namespace Mainto\DDDCore\Relation;


class BelongsToDefaultProvider implements BelongsToProvider {
    /**
     * @var string
     */
    private string $ownerKey;

    /**
     * @var string
     */
    private string $foreignKey;

    /**
     * @var array
     */
    private array $modelToOne;

    /**
     * @var array
     */
    private array $modelsToOne;

    public function __construct (string $foreignKey, string $ownerKey, array $modelToOne, array $modelsToOne) {
        $this->ownerKey = $ownerKey;
        $this->foreignKey = $foreignKey;
        $this->modelToOne = $modelToOne;
        $this->modelsToOne = $modelsToOne;
    }

    public function getOwnerKey (): string {
        return $this->ownerKey;
    }

    public function getForeignKey (): string {
        return $this->foreignKey;
    }

    public function modelToOne (): array {
        return $this->modelToOne;
    }

    public function modelsToOne (): array {
        return $this->modelsToOne;
    }
}