<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Exception\MissRelationResultProvider;

/**
 * Class BelongsTo
 * @package Mainto\DDDCore\Relation
 */
class BelongsTo implements Relationship {
    /**
     * @var BelongsToProvider
     */
    private BelongsToProvider $provider;

    /**
     * @param BelongsToProvider $provider
     * @return static
     */
    public static function from(BelongsToProvider $provider): self {
        return new self($provider);
    }

    /**
     * HasMany constructor.
     * @param BelongsToProvider $provider
     */
    public function __construct (BelongsToProvider $provider) {
        $this->provider = $provider;
    }

    /**
     * @return string
     */
    public function getForeignKey (): string {
        return $this->provider->getForeignKey();
    }

    /**
     * @return string
     */
    public function getOwnerKey (): string {
        return $this->provider->getOwnerKey();
    }

    /**
     * @param $id
     * @return object
     */
    public function modelResult ($id): object {
        $call = $this->provider->modelToOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($id);
    }

    /**
     * @param $ids
     * @return iterable
     */
    public function modelsResult ($ids): iterable {
        $call = $this->provider->modelsToOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($ids);
    }

    public function getCurrentKey (): string {
        return $this->getForeignKey();
    }

    public function getTargetKey (): string {
        return $this->getOwnerKey();
    }
}