<?php

namespace Mainto\DDDCore\Support\VO;

use Mainto\DDDCore\Interfaces\ValueObject;

/**
 * Class PageData
 * @package  App\Domain\Common\Vo
 * @template T
 */
class PageDataVO implements ValueObject {
    /**
     * @var int
     */
    public int $page;

    /**
     * @var int
     */
    public int $total;

    /**
     * @var array
     */
    public array $data;

    /**
     * PageData constructor.
     * @param int $page
     * @param int $total
     * @param array<T> $data
     */
    public function __construct (int $page, int $total, array $data) {
        $this->page = $page;
        $this->total = $total;
        $this->data = $data;
    }

    public function sameValueAs (ValueObject $other): bool {
        return false;
    }
}
