<?php

namespace Mainto\DDDCore\Command;

use Illuminate\Console\Command;

/**
 * Class MakeValueObject
 * @package Mainto\DDDCore\Command
 */
class MakeValueObject extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ddd:make-vo {domain} {vo} {dataType} {--vo-interface=} {--base_path} {--base_namespace}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'DDD Command Make ValueObject';

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $domain = $this->argument('domain');
        $vo = rtrim($this->argument('vo'), 'VO').'VO';
        $dataType = $this->argument('dataType');
        $voInterface = value_if($this->option('vo-interface'), config('ddd.vo_interface'));
        $basePath = value_if($this->option('base_path'), app_path());
        $baseNamespace = value_if($this->option('base_namespace'), "App");


        if (!in_array($dataType, $this->dataTypes())) {
            $this->error("the data type only support: ".implode('|', $this->dataTypes()));
            return;
        }

        $path = sprintf("%s/Domain/%s/Model/VO/%s.php", $basePath, $domain, $vo);
        if (file_exists($path)) {
            $res = $this->ask("the vo object exists at ".$path.', overwrite it? (yes/no)', 'no');
            if (!$res) {
                $this->warn("Command Cancelled!");
                return;
            }
        }

        file_put_contents(
            $path,
            "<?php\n".view('value-object', [
                'namespace'       => sprintf("%s\Domain\%s\Model\VO", $baseNamespace, $domain),
                'voInterface'     => $voInterface,
                'valueObjectName' => $vo,
                'dataType'        => $dataType,
            ])->render()
        );
    }

    private function dataTypes (): array {
        return [
            'bool',
            'int',
            'string',
            'float',
            'array',
        ];
    }
}
