<?php


namespace Mainto\DDDCore\Relation;


class HasManyDefaultProvider implements HasManyProvider {
    private string $localKey;
    private string $targetKey;
    private array $modelToMany;
    private array $modelsToMany;

    public function __construct (string $localKey, string $targetKey, array $modelToMany, array $modelsToMany) {
        $this->localKey = $localKey;
        $this->targetKey = $targetKey;
        $this->modelToMany = $modelToMany;
        $this->modelsToMany = $modelsToMany;
    }

    public function getLocalKey (): string {
        return $this->localKey;
    }

    public function getForeignKey (): string {
        return $this->targetKey;
    }

    public function modelToMany (): array {
        return $this->modelToMany;
    }

    public function modelsToMany (): array {
        return $this->modelsToMany;
    }
}
