<?php


namespace Mainto\DDDCore\Relation;

trait ModelRelationTrait {
    private array $relations = [];

    /**
     * @param string $localKey
     * @param string $targetKey
     * @param array $modelToMany
     * @param array $modelsToMany
     * @return HasMany
     */
    public function hasMany (string $localKey, string $targetKey, array $modelToMany = [], array $modelsToMany = []): HasMany {
        return new HasMany(new HasManyDefaultProvider($localKey, $targetKey, $modelToMany, $modelsToMany));
    }

    /**
     *
     * @param string|array $localKey
     * @param string $targetKey
     * @param array $modelToOne
     * @param array $modelsToOne
     * @return HasOne
     */
    public function hasOne ($localKey, string $targetKey, array $modelToOne = [], array $modelsToOne = []): HasOne {
        return new HasOne(new HasOneDefaultProvider($localKey, $targetKey, $modelToOne, $modelsToOne));
    }

    /**
     *
     * @param string $foreignKey
     * @param string $ownerKey
     * @param array $modelToOne
     * @param array $modelsToOne
     * @return BelongsTo
     */
    public function belongsTo (string $foreignKey, string $ownerKey, array $modelToOne, array $modelsToOne): BelongsTo {
        return new BelongsTo(new BelongsToDefaultProvider($foreignKey, $ownerKey, $modelToOne, $modelsToOne));
    }


    public function __get ($name) {
        if (array_key_exists($name, $this->relations)) {
            return $this->relations[$name];
        }

        if (method_exists($this, $name)) {
            $relation = $this->{$name}();
            if ($relation instanceof Relationship) {
                $keys = (array)$relation->getCurrentKey();
                $params = [];
                foreach ($keys as $key) {
                    $value = getter($this, $key);
                    if (is_null($value)) {
                        return $this->relations[$name] = null;
                    }
                    $params[] = $value;
                }

                return $this->relations[$name] = $relation->modelResult(...$params);
            }
        }
    }

    public function setRelation ($relation, $value): self {
        $this->relations[$relation] = $value;

        return $this;
    }

    public function refresh ($relation): self {
        if (array_key_exists($relation, $this->relations)) {
            unset($this->relations[$relation]);
        }

        return $this;
    }
}
