<?php


namespace Mainto\DDDCore\Relation;


/**
 * Interface BelongsToProvider
 * @package Mainto\DDDCore\Relation
 * @template T
 */
interface BelongsToProvider {
    /**
     * @return string
     */
    public function getForeignKey (): string;

    /**
     * @return string
     */
    public function getOwnerKey (): string;

    /**
     * [class, method]
     * @return array<T>
     */
    public function modelToOne(): array;

    /**
     * [class, method]
     * @return array<T>
     */
    public function modelsToOne(): array;
}