<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Exception\MissRelationResultProvider;
use Mainto\DDDCore\Interfaces\Entity;

class HasOne implements Relationship {
    /**
     * @var HasOneProvider
     */
    private HasOneProvider $provider;

    public static function from(HasOneProvider $provider): self {
        return new self($provider);
    }

    /**
     * HasMany constructor.
     * @param HasOneProvider $provider
     */
    public function __construct (HasOneProvider $provider) {
        $this->provider = $provider;
    }

    /**
     * @return string
     */
    public function getForeignKey (): string {
        return $this->provider->getForeignKey();
    }

    /**
     * @return string
     */
    public function getLocalKey (): string {
        return $this->provider->getLocalKey();
    }

    /**
     * @param $id
     * @return Entity
     */
    public function modelResult ($id): Entity {
        $call = $this->provider->modelToOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($id);
    }

    /**
     * @param $ids
     * @return iterable
     */
    public function modelsResult ($ids): iterable {
        $call = $this->provider->modelsToOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($ids);
    }

    public function getCurrentKey (): string {
        return $this->getLocalKey();
    }

    public function getTargetKey (): string {
        return $this->getForeignKey();
    }
}
