<?php


namespace Mainto\DDDCore\Relation;


class HasManyDefaultProvider implements HasManyProvider {
    private string $localKey;
    private string $targetKey;
    private array $entityToMany;
    private array $entitiesToMany;

    public function __construct (string $localKey, string $targetKey, array $entityToMany, array $entitiesToMany) {
        $this->localKey = $localKey;
        $this->targetKey = $targetKey;
        $this->entityToMany = $entityToMany;
        $this->entitiesToMany = $entitiesToMany;
    }

    public function getLocalKey (): string {
        return $this->localKey;
    }

    public function getForeignKey (): string {
        return $this->targetKey;
    }

    public function modelToMany (): array {
        return $this->entityToMany;
    }

    public function modelsToMany (): array {
        return $this->entitiesToMany;
    }
}
