<?php


namespace Mainto\DDDCore\Relation;


class BelongsToDefaultProvider implements BelongsToProvider {
    /**
     * @var string
     */
    private string $ownerKey;

    /**
     * @var string
     */
    private string $foreignKey;

    /**
     * @var array
     */
    private array $entityToOne;

    /**
     * @var array
     */
    private array $entitiesToOne;

    public function __construct (string $foreignKey, string $ownerKey, array $entityToOne, array $entitiesToOne) {
        $this->ownerKey = $ownerKey;
        $this->foreignKey = $foreignKey;
        $this->entityToOne = $entityToOne;
        $this->entitiesToOne = $entitiesToOne;
    }

    public function getOwnerKey (): string {
        return $this->ownerKey;
    }

    public function getForeignKey (): string {
        return $this->foreignKey;
    }

    public function entityToOne (): array {
        return $this->entityToOne;
    }

    public function entitiesToOne (): array {
        return $this->entitiesToOne;
    }
}