<?php


namespace Mainto\DDDCore\Relation;


/**
 * Interface BelongsToProvider
 * @package Mainto\DDDCore\Relation
 * @template T
 */
interface BelongsToProvider {
    /**
     * @return string
     */
    public function getForeignKey (): string;

    /**
     * @return string
     */
    public function getOwnerKey (): string;

    /**
     * @return array<T>
     */
    public function entityToOne(): array;

    /**
     * @return array<T>
     */
    public function entitiesToOne(): array;
}