<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Exception\MissRelationResultProvider;
use Mainto\DDDCore\Interfaces\Entity;

class HasOne {
    /**
     * @var HasOneProvider
     */
    private HasOneProvider $provider;

    /**
     * HasMany constructor.
     * @param HasOneProvider $provider
     */
    public function __construct (HasOneProvider $provider) {
        $this->provider = $provider;
    }

    public function getLocalKey (): string {
        return $this->provider->getLocalKey();
    }

    public function getTargetKey (): string {
        return $this->provider->getTargetKey();
    }

    public function entityResult ($id): Entity {
        $call = $this->provider->entityOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($id);
    }

    public function entitiesResult ($ids): array {
        $call = $this->provider->entitiesOne();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($ids);
    }
}
