<?php


namespace Mainto\DDDCore\Relation;


class HasManyDefaultProvider implements HasManyProvider {
    private string $localKey;
    private string $targetKey;
    private array $entityMany;
    private array $entitiesMany;

    public function __construct (string $localKey, string $targetKey, array $entityToMany, array $entitiesToMany) {
        $this->localKey = $localKey;
        $this->targetKey = $targetKey;
        $this->entityMany = $entityToMany;
        $this->entitiesMany = $entitiesToMany;
    }

    public function getLocalKey (): string {
        return $this->localKey;
    }

    public function getTargetKey (): string {
        return $this->targetKey;
    }

    public function entityToMany (): array {
        return $this->entityMany;
    }

    public function entitiesToMany (): array {
        return $this->entitiesMany;
    }
}
