<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Exception\MissRelationResultProvider;

/**
 * Class HasMany
 * @package Mainto\DDDCore\Relation
 */
class HasMany {
    /**
     * @var HasManyProvider
     */
    private HasManyProvider $provider;

    /**
     * HasMany constructor.
     * @param HasManyProvider $provider
     */
    public function __construct (HasManyProvider $provider) {
        $this->provider = $provider;
    }

    public function getLocalKey (): string {
        return $this->provider->getLocalKey();
    }

    public function getTargetKey (): string {
        return $this->provider->getTargetKey();
    }

    public function entityResult ($id): array {
        $call = $this->provider->entitiesToMany();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($id);
    }

    public function entitiesResult ($ids): array {
        $call = $this->provider->entitiesToMany();
        if (!$call) {
            throw new MissRelationResultProvider();
        }

        [$class, $method] = $call;

        return app($class)->{$method}($ids);
    }
}
