<?php


namespace Mainto\DDDCore\Relation;

use Mainto\DDDCore\Interfaces\Entity;

trait EntityRelationTrait {
    private array $relations = [];

    public function hasMany($localKey, $targetKey, $targetCall): HasMany {
        /** @var Entity $this */
        return new HasMany($this, $localKey, $targetKey, $targetCall);
    }

    public function __get ($name) {
        if (array_key_exists($name, $this->relations)) {
            return $this->relations[$name];
        }

        if (method_exists($this, $name)) {
            $relation = $this->{$name}();
            if ($relation instanceof HasMany) {
                $res = $relation->getResults();
                $this->relations[$name] = $res;

                return $this->relations[$name];
            }
        }
    }

    public function setRelation($relation, $value): self {
        $this->relations[$relation] = $value;

        return $this;
    }

    public function refresh($relation): self {
        if (array_key_exists($relation, $this->relations)) {
            unset($this->relations[$relation]);
        }

        return $this;
    }
}
