<?php


namespace Mainto\DDDCore\Relation;


use Mainto\DDDCore\Interfaces\Entity;

/**
 * Class HasMany
 * @package Mainto\DDDCore\Relation
 */
class HasMany {
    /**
     * @var string
     */
    private string $localKey;

    /**
     * @var array
     */
    private array $targetCall;

    /**
     * @var Entity
     */
    private Entity $localEntity;

    /**
     * @var string
     */
    private string $targetKey;

    /**
     * HasMany constructor.
     * @param Entity $localEntity
     * @param string $localKey
     * @param string $targetKey
     * @param array $targetCall
     */
    public function __construct (Entity $localEntity, string $localKey, string $targetKey, array $targetCall) {
        $this->targetKey = $targetKey;
        $this->localEntity = $localEntity;
        $this->localKey = $localKey;
        $this->targetCall = $targetCall;
    }

    /**
     * @return array
     */
    public function getResults(): array {
        return app($this->targetCall[0])->{$this->targetCall[1]}([$this->localEntity->{$this->localKey}]);
    }

    /**
     * @return string
     */
    public function getLocalKey (): string {
        return $this->localKey;
    }

    /**
     * @return array
     */
    public function getTargetCall (): array {
        return $this->targetCall;
    }

    /**
     * @return string
     */
    public function getTargetKey (): string {
        return $this->targetKey;
    }
}
