<?php

namespace Mainto\DDDCore\Command;

use Illuminate\Console\Command;

/**
 * Class MakeValueObject
 * @package Mainto\DDDCore\Command
 */
class MakeValueObject extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ddd:make-vo {domain} {vo} {dataType} {--vo-interface=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'DDD Command Make ValueObject';

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $domain = $this->argument('domain');
        $vo = $this->argument('vo');
        $dataType = $this->argument('dataType');
        $voInterface = $this->option('vo-interface');
        if (!$voInterface) {
            $voInterface = config('ddd.vo_interface');
        }
        if (!in_array($dataType, $this->dataTypes())) {
            $this->error("the data type only support: ".implode('|', $this->dataTypes()));
            return;
        }

        $path = app_path(sprintf("Domain/%s/Model/Vo/%s.php", $domain, $vo));
        if (file_exists($path)) {
            $res = $this->ask("the vo object exists at ".$path. ', overwrite it? (yes/no)', 'no');
            if (!$res) {
                $this->warn("Command Cancelled!");
                return;
            }
        }

        file_put_contents(
            $path,
            "<?php\n".view('value-object', [
                'namespace'       => sprintf("App\Domain\%s\Model\Vo", $domain),
                'voInterface'     => $voInterface,
                'valueObjectName' => $vo,
                'dataType'        => $dataType,
            ])->render()
        );
    }

    private function dataTypes (): array {
        return [
            'bool',
            'int',
            'string',
            'float',
            'array',
        ];
    }
}
