<?php


namespace Mainto\DDDCore\Provider;


use Mainto\DDDCore\Command\MakeValueObject;
use Illuminate\Support\ServiceProvider;
use ReflectionClass;
use ReflectionException;

class DDDProvider extends ServiceProvider {
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/config.php' => config_path('ddd.php'),
            ], 'config');
        }
    }

    /**
     * @throws ReflectionException
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/config.php', 'ddd');

        $this->app['config']->set('view.paths', array_merge($this->app['config']->get('view.paths'), [
            __DIR__.'/Command',
        ]));

        $this->app->bind('command.ddd.make.vo', MakeValueObject::class);

        $this->commands([
            'command.ddd.make.vo',
        ]);

        if (config('ddd.auto_register.repository.enable')) {
            $registerMode = config('ddd.auto_register.repository.mode');
            foreach (get_classes(app_path(config('ddd.auto_register.repository.scan_dir'))) as $class) {
                $ref = new ReflectionClass($class);
                foreach ($ref->getInterfaceNames() as $interfaceName) {
                    $this->app->$registerMode($interfaceName, $class);
                }
            }
        }
    }
}
