<?php

namespace Mainto\Debug\Middlewares;

use Closure;
use Mainto\Debug\Reporter\Reporter;
use Throwable;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\KernelMiddleware;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class XdebugKernelMiddleware implements KernelMiddleware {
    /**
     * @param RpcStreamContext $context
     * @param Closure $next
     * @return Response
     * @throws Throwable
     */
    public function handle (RpcStreamContext $context, Closure $next): Response {
        xdebug_start_code_coverage();
        try {
            return $next($context);
        } finally {
            Reporter::getInstance()->upload(xdebug_get_code_coverage());
        }
    }
}