<?php

namespace Mainto\Debug\Reporter;

use GuzzleHttp\Client;
use Throwable;

class HttpHandler implements ReporterInterface {

    /**
     * @var string
     */
    protected string $uri;

    /**
     * 实例化
     */
    public function __construct() {
        $this->uri = env('DEBUG_COVERAGE_URI', false);
    }

    /**
     * @param array $data
     * @return void
     * @throws Throwable
     */
    public function upload (array $data = []): void {
        if (empty($this->uri)) {
            return;
        }
        (new Client())->post($this->uri, ['json' => $data]);
    }
}