<?php
namespace Mainto\Debug;

use Illuminate\Events\EventServiceProvider;
use Mainto\RpcServer\RpcServer\Kernel;

class DebugProvider extends EventServiceProvider {
    /**
     * @return void
     */
    public function register () {
        $this->bind();
    }

    /**
     * 进行对象绑定
     *
     * @return void
     */
    private function bind (): void {
        // 获取环境变量，确定是否需要开启xdebug
        if (env('DEBUG_COVERAGE_OPEN', false) && function_exists('xdebug_start_code_coverage')) {
            $this->app->bind(Kernel::class, function ($app, array $params = []) {
                return new DebugKernel($params['conn'], $params['streamId']);
            });
        }
    }
}